<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Groupe extends Model 
{

    protected $table = 'groupes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'banner', 'description', 'status', 'id_user');
    protected $visible = array('name', 'banner', 'description', 'status', 'id_user');

    public function certifications()
    {
        return $this->morphMany('App\Models\Certification', 'certifiable_id');
    }

    public function posts()
    {
        return $this->hasMany('App\Models\Post', 'id_group');
    }

}